<?php

/**
 * BaseAssignment
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int         $id                       Type: integer(4), primary key
 * @property int         $user_id                  Type: integer(4)
 * @property int         $team_id                  Type: integer(4)
 * @property int         $state                    Type: integer(2), default "0"
 * @property string      $invited                  Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string      $confirmed                Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string      $cancelled                Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property User        $User                     
 * @property WRTeam      $WRTeam                   
 *  
 * @method int           getId()                   Type: integer(4), primary key
 * @method int           getUserId()               Type: integer(4)
 * @method int           getTeamId()               Type: integer(4)
 * @method int           getState()                Type: integer(2), default "0"
 * @method string        getInvited()              Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string        getConfirmed()            Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string        getCancelled()            Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method User          getUser()                 
 * @method WRTeam        getWRTeam()               
 *  
 * @method Assignment    setId(int $val)           Type: integer(4), primary key
 * @method Assignment    setUserId(int $val)       Type: integer(4)
 * @method Assignment    setTeamId(int $val)       Type: integer(4)
 * @method Assignment    setState(int $val)        Type: integer(2), default "0"
 * @method Assignment    setInvited(string $val)   Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Assignment    setConfirmed(string $val) Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Assignment    setCancelled(string $val) Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Assignment    setUser(User $val)        
 * @method Assignment    setWRTeam(WRTeam $val)    
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseAssignment extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('assignments');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('user_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('team_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('state', 'integer', 2, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => '2',
             ));
        $this->hasColumn('invited', 'timestamp', 25, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '25',
             ));
        $this->hasColumn('confirmed', 'timestamp', 25, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '25',
             ));
        $this->hasColumn('cancelled', 'timestamp', 25, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '25',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('User', array(
             'local' => 'user_id',
             'foreign' => 'id'));

        $this->hasOne('WRTeam', array(
             'local' => 'team_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $datetimebehavior0 = new DateTimeBehavior();
        $this->actAs($datetimebehavior0);
    }
}