<?php

use function ZWE\count_safe;

/**
 * Startgroup
 *
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class Startgroup extends BaseStartgroup
{
	/**
	 * Gibt eine String-Repräsentation der wichtigen Flags zurück.
	 * @return string Flags, z.B. EAV
	 */
	public function getFlags()
	{
		$flags = '';
		if ($this->isBuiltin()) {
			$flags .= 'E';
		} else {
			$flags .= '-';
		}
		if ($this->enabled) {
			$flags .= 'A';
		} else {
			$flags .= '-';
		}
		if ($this->isInUse()) {
			$flags .= 'V';
		} else {
			$flags .= '-';
		}
		return $flags;
	}

	/**
	 * Gibt zurück, ob es sich um eine eingebaute (und damit nicht editierbare)
	 * Startgruppe handelt
	 * @return boolean
	 */
	public function isBuiltin()
	{
		return $this->builtin == 0 ? false : true;
	}

	/**
	 * Gibt zurück, ob die Startgruppe verwendet wird.
	 * @return boolean
	 */
	public function isInUse()
	{
		return count_safe($this->Competitions) > 0;
	}

}