<?php

/**
 * PersistentDate
 *
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class PersistentDate extends BasePersistentDate
{

	public function getValue()
	{
		return $this->getDateTimeObject('persistent_date');
	}

	public function setValue(DateTime $dateTime)
	{
		$this->setDateTimeObject('persistent_date', $dateTime);
	}

	public static function newWithGeneratedId($group)
	{
		$uuid = new \ZWE\UUID();
		return self::newInstance($uuid->generate(), $group);
	}

	public static function newInstance($id, $group)
	{
		$pd = new PersistentDate();
		$pd->id = $id;
		$pd->dategroup = $group;
		return $pd;
	}

}