<?php

/**
 * License
 *
 * @package    models
 * @subpackage doctrine
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class License extends BaseLicense
{

	const PRIO_MAX_VALUE = 255;

	const TYPE_EINZEL = 'E';
	const TYPE_FORMATION = 'F';

	/**
	 * Gibt eine String-Repräsentation der wichtigen Flags zurück.
	 * @return string Flags, z.B. EA
	 */
	public function getFlags()
	{
		$flags = '';
		if ($this->isBuiltin()) {
			$flags .= 'E';
		} else {
			$flags .= '-';
		}
		if ($this->enabled) {
			$flags .= 'A';
		} else {
			$flags .= '-';
		}
		return $flags;
	}

	/**
	 * Gibt den Lizenztyp zurück.
	 * @return string Lizenztyp, E für Einzelwettbewerbe, F für Formationswettbewerbe.
	 */
	public function getType()
	{
		return $this->type;
	}

	/**
	 * Gibt zurück, ob es sich um eine eingebaute (und damit nicht editierbare)
	 * Lizenz handelt.
	 * @return boolean
	 */
	public function isBuiltin()
	{
		return $this->builtin == 0 ? false : true;
	}

	/**
	 * Gibt zurück, ob es sich um eine nur effektive Lizenz handelt.
	 * @return boolean
	 */
	public function isOnlyEffective()
	{
		return $this->effective == 0 ? false : true;
	}
}