<?php

/**
 * Assignmentplan
 *
 * @package    models
 * @subpackage doctrine
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class Assignmentplan extends BaseAssignmentplan
{

	public function isValidAssignmentPlan()
	{
		return $this->valid == 1 ? true : false;
	}

	public static function newInstance(Event $event)
	{
		$ap = new Assignmentplan();
		$ap->setDateTimeObject('datum', new DateTime());
		$ap->setValid(true);
		$ap->Event = $event;
		return $ap;
	}

	public function getSaveFilename()
	{
		return sprintf('%s-%s-%s_Einsatzplan.pdf', $this->Event->getDateTimeObject('datum')->format('Ymd'), $this->Event->id, $this->id);
	}

	public function getExportFilename()
	{
		return sprintf('%s-%s-%s_Export.zwex', $this->Event->getDateTimeObject('datum')->format('Ymd'), $this->Event->id, $this->id);
	}

	public function setValid($valid)
	{
		$this->valid = $valid === true ? 1 : 0;
	}

}