<?php

/**
 * Assignment
 *
 * @package    models
 * @subpackage doctrine
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class Assignment extends BaseAssignment
{

	const STATE_CANCELLED = -1;
	const STATE_DEFAULT = 0;
	const STATE_INVITED = 1;
	const STATE_CONFIRMED = 2;

	public static function allStates()
	{
		return array(self::STATE_CANCELLED, self::STATE_DEFAULT, self::STATE_INVITED, self::STATE_CONFIRMED);
	}

	public static function allStatesNotCancelled()
	{
		return array(self::STATE_DEFAULT, self::STATE_INVITED, self::STATE_CONFIRMED);
	}

	public function cancel($save = false)
	{
		$this->state = self::STATE_CANCELLED;
		$this->confirmed = null;
		$this->setDateTimeObject('cancelled', new DateTime());
		// @codeCoverageIgnoreStart
		if ($save) {
			$this->save();
		}
		// @codeCoverageIgnoreEnd
	}

	public function confirm($save = false)
	{
		$this->state = self::STATE_CONFIRMED;
		$this->cancelled = null;
		$this->setDateTimeObject('confirmed', new DateTime());
		// @codeCoverageIgnoreStart
		if ($save) {
			$this->save();
		}
		// @codeCoverageIgnoreEnd
	}

	public function getStatusText()
	{
		return self::getStatusTextStatic($this->state);
	}

	public static function getStatusTextStatic($state)
	{
		switch ($state) {
			case self::STATE_CANCELLED:
				return "abgesagt";
			case self::STATE_CONFIRMED:
				return "zugesagt";
			case self::STATE_DEFAULT:
				return "eingesetzt";
			case self::STATE_INVITED:
			default:
				return "eingeladen";
		// @codeCoverageIgnoreStart
		}
		// @codeCoverageIgnoreEnd
	}

	public function invited($save = false)
	{
		$this->state = self::STATE_INVITED;
		$this->setDateTimeObject('invited', new DateTime());
		// @codeCoverageIgnoreStart
		if ($save) {
			$this->save();
		}
		// @codeCoverageIgnoreEnd
	}

	public function isConfirmed()
	{
		return $this->state == self::STATE_CONFIRMED;
	}

	public function isCancelled()
	{
		return $this->state == self::STATE_CANCELLED;
	}

	public function isDefault()
	{
		return $this->state == self::STATE_DEFAULT;
	}

	public function isInvited()
	{
		return $this->state == self::STATE_INVITED;
	}
}