<?php
require_once(__DIR__ . '/../tools/read_countries_csv.php');

/**
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class Version75 extends Doctrine_Migration_Base
{
    public function up()
    {
        $this->createTable('countries', array(
             'id' =>
             array(
              'type' => 'integer',
              'unsigned' => '0',
              'primary' => '1',
              'autoincrement' => '1',
              'length' => '4',
             ),
             'name' =>
             array(
              'type' => 'string',
              'fixed' => '0',
              'notnull' => '1',
              'primary' => '',
              'length' => '64',
             ),
             'ioc' =>
             array(
              'type' => 'string',
              'fixed' => '1',
              'notnull' => '1',
              'primary' => '',
              'length' => '3',
             ),
             'alpha3' =>
             array(
              'type' => 'string',
              'fixed' => '1',
              'notnull' => '1',
              'primary' => '',
              'length' => '3',
             ),
             'active' =>
             array(
              'type' => 'boolean',
              'notnull' => '1',
              'length' => '25',
             ),
             ), array(
             'indexes' =>
             array(
              'ix_countries_ioc' =>
              array(
              'fields' =>
              array(
               0 => 'ioc',
              ),
              'unique' => '1',
              ),
              'ix_countries_alpha3' =>
              array(
              'fields' =>
              array(
               0 => 'alpha3',
              ),
              'unique' => '1',
              ),
             ),
             'primary' =>
             array(
              0 => 'id',
             ),
             'collate' => 'utf8_general_ci',
             'charset' => 'utf8',
             ));
    }

    public function down()
    {
        $this->dropTable('countries');
    }

    public function postUp() {
        $countries = read_countries_csv();
        foreach($countries as $c) {
            $country = new \Country();
	        $country->id = $c->id;
	        $country->name = $c->name;
	        $country->ioc = $c->ioc;
	        $country->alpha3 = $c->alpha3;
	        $country->active = true;
	        $country->save();
        }
    }
}