<?php
/**
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class Version30 extends Doctrine_Migration_Base
{
    public function up()
    {
		$this->addColumn('licenses', 'prio', 'integer', '1', array(
             'unsigned' => '1',
             'primary' => '',
             'autoincrement' => '',
             'notnull' => '1',
             'default' => '255',
             ));
                $this->renameColumn('licenses', 'user_selectable', 'enabled');
                $this->renameColumn('licenses', 'only_effective', 'effective');
    }

    public function postUp()
    {
        // set the correct prios
        $query = Doctrine_Query::create()
            ->select('l.id, l.shortname')
            ->from('License l');
        $licenses = $query->execute();
        foreach($licenses as $l) {
            switch($l->shortname) {
                case 'S':
                    $l->prio = 1;
                    break;
                case 'A':
                    $l->prio = 2;
                    break;
                case 'B':
                    $l->prio = 3;
                    break;
                case 'C':
                    $l->prio = 4;
                    break;
                case 'D':
                    $l->prio = 5;
                    break;
                case '-':
                    $l->prio = 255;
                    $l->name = 'keine';
                    break;
            }
            $l->save();
        }
    }

    public function preDown() {
        $query = Doctrine_Query::create()
            ->select('l.id, l.name')
            ->from('License l')
            ->where('l.name = ?', 'keine');
        $lk = $query->fetchOne();
        if($lk !== false) {
            $lk->name = '---';
            $lk->save();
        }
    }

    public function down()
    {
		$this->removeColumn('licenses', 'prio');
                $this->renameColumn('licenses', 'enabled', 'user_selectable');
                $this->renameColumn('licenses', 'effective', 'only_effective');
    }
}