<?php
declare(strict_types=1);

namespace ZWE;

/**
 * Counts array or \Countable, returns 0 if value is not an array or a \Countable
 * @param mixed $value
 * @return int
 */
function count_safe($value): int
{
	if (is_array($value)) {
		return count($value);
	} elseif (interface_exists('\Countable') && $value instanceof \Countable) {
		return count($value);
	} else {
		return 0;
	}
}
