<?php
namespace ZWE\User;

use ZWE\Context\CISessionContextHolder;
use ZWE\Repository\UserRepository;

/**
 * ContextHolder, der den aktuellen Benutzer-Kontext in der
 * CodeIgniter-Session speichert.
 *
 * Dabei wird lediglich die User-ID in der Session gespeichert und das
 * Mandanten-Objekt bei Bedarf aus der Datenbank geladen.
 *
 * @author  Hendrik Heneke <hendrik@pixelwunder.net>
 * @since   2.5
 */
class UserCISessionContextHolder extends CISessionContextHolder
{

	private $repo;

	public function __construct()
	{
		parent::__construct();
		$this->repo = new UserRepository();
	}

	protected function getSessionKey()
	{
		return 'ZWE-USER-ID';
	}

	protected function retrieveFromContext()
	{
		return $this->repo->find($this->retrieveValueFromCISession());
	}

	protected function saveInContext($user)
	{
		$this->saveValueInCISession($user->id);
	}

}