<?php
namespace ZWE;

class UUID
{

	const KERNEL_UUID = '/proc/sys/kernel/random/uuid';

	/**
	 * @param bool $forceDb
	 * @return string
	 * @throws \RuntimeException
	 */
	public function generate($forceDb = false)
	{
		if (!$forceDb && @file_exists(self::KERNEL_UUID)) {
			// @codeCoverageIgnoreStart
			return trim(file_get_contents(self::KERNEL_UUID));
			// @codeCoverageIgnoreEnd
		} else {
			$result = \Doctrine_Manager::getInstance()->getCurrentConnection()->fetchColumn('SELECT uuid()');
			if (isset($result[0])) {
				return $result[0];
			} else {
				// @codeCoverageIgnoreStart
				throw new \RuntimeException("UUID konnte nicht generiert werden!");
				// @codeCoverageIgnoreEnd
			}
		}
	}

	/**
	 * @return string
	 */
	public static function randomUUID()
	{
		$u = new UUID();
		return $u->generate();
	}

}
