<?php
namespace ZWE\Settings;

class SettingsRegistry
{

	private static $instance;

	private $settings = array();

	public function __construct()
	{

		$default_footer_html = '<p><i>
ZWE LTV<br/>
Web: <a href="http://www.ltv.de/zwe/">www.ltv.de/zwe/</a><br/>
E-Mail: <a href="mailto:zwe@ltv.de">zwe@ltv.de</a>
</i></p>';

		$this->settings['mail_footer_html'] = new Setting('mail_footer_html', Setting::TYPE_TEXT, Setting::CATEGORY_MANDATOR, $default_footer_html, true);
		$this->settings['mail_from'] = new Setting('mail_from', Setting::TYPE_STRING, Setting::CATEGORY_MANDATOR, 'ZWE LTV', true);
		$this->settings['mail_subject_prefix'] = new Setting('mail_subject_prefix', Setting::TYPE_STRING, Setting::CATEGORY_MANDATOR, '[ZWE LTV]', true);
		$this->settings['mail_zwe_recipient'] = new Setting('mail_zwe_recipient', Setting::TYPE_STRING, Setting::CATEGORY_MANDATOR, 'zwe@ltv.de', true, 'valid_email');
		$this->settings['mail_reg_recipient'] = new Setting('mail_reg_recipient', Setting::TYPE_STRING, Setting::CATEGORY_MANDATOR, '', false, 'valid_email');
		$this->settings['mail_cancel_recipient'] = new Setting('mail_cancel_recipient', Setting::TYPE_STRING, Setting::CATEGORY_MANDATOR, '', false, 'valid_email');
		$this->settings['mail_plan_recipient'] = new Setting('mail_plan_recipient', Setting::TYPE_STRING, Setting::CATEGORY_MANDATOR, '', false, 'valid_email');
		$this->settings['mail_zwe_sender'] = new Setting('mail_zwe_sender', Setting::TYPE_STRING, Setting::CATEGORY_MANDATOR, 'zwe@ltv.de', true, 'valid_email');
		$this->settings['mail_max_recipients_per_message'] = new Setting('mail_max_recipients_per_message', Setting::TYPE_NUMERIC, Setting::CATEGORY_SYSTEM, 0, true);
		$this->settings['mail_max_messages_per_minute'] = new Setting('mail_max_messages_per_minute', Setting::TYPE_NUMERIC, Setting::CATEGORY_SYSTEM, 0, true);
		$this->settings['mail_dkim_privatekey'] = new Setting('mail_dkim_privatekey', Setting::TYPE_TEXT, Setting::CATEGORY_SYSTEM, '', false);
		$this->settings['mail_dkim_domain'] = new Setting('mail_dkim_domain', Setting::TYPE_STRING, Setting::CATEGORY_SYSTEM, '', false);
		$this->settings['mail_dkim_selector'] = new Setting('mail_dkim_selector', Setting::TYPE_STRING, Setting::CATEGORY_SYSTEM, '', false);
		$this->settings['ui_pagetitle'] = new Setting('ui_pagetitle', Setting::TYPE_STRING, Setting::CATEGORY_SYSTEM, 'LTV', true);
		$this->settings['ui_skin'] = (new Setting('ui_skin', Setting::TYPE_OPTIONS, Setting::CATEGORY_SYSTEM, 'default', true))
			->setOptions(['default' => 'Standard', 'modern' => 'Modern']);
		$this->settings['ui_theme'] = (new Setting('ui_theme', Setting::TYPE_OPTIONS, Setting::CATEGORY_SYSTEM, 'default', true))
			->setOptions(['default' => 'Standard', 'bayern' => 'LTV Bayern', 'htv' => 'HTV', 'tnw' => 'TNW', 'trp' => 'TRP', 'tsh-hatv' => 'TSH/HATV', 'berlin' => 'Berlin']);
		$this->settings['ui_filter_use_localstorage'] = new Setting('ui_filter_use_localstorage', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, false, true);
		$this->settings['zwe_allow_licenseedit'] = new Setting('zwe_allow_licenseedit', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, FALSE, true);
		$this->settings['zwe_autoadd_workdays'] = new Setting('zwe_autoadd_workdays', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, FALSE, true);
		$this->settings['zwe_cancellation_period'] = new Setting('zwe_cancellation_period', Setting::TYPE_NUMERIC, Setting::CATEGORY_MANDATOR, 8, true, 'integer');
		$this->settings['zwe_cancellation_message'] = new Setting('zwe_cancellation_message', Setting::TYPE_TEXT, Setting::CATEGORY_MANDATOR, 'Bitte wenden Sie sich an den o.g. Ansprechpartner.', true);
		$this->settings['zwe_ltv'] = new Setting('zwe_ltv', Setting::TYPE_LTV, Setting::CATEGORY_MANDATOR, 'Berlin', true);
		$this->settings['zwe_registration_enabled'] = new Setting('zwe_registration_enabled', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, true, true);
		$this->settings['zwe_registration_foreign_enabled'] = new Setting('zwe_registration_foreign_enabled', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, true, true);
		$this->settings['zwe_show_calendar'] = new Setting('zwe_show_calendar', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, FALSE, true);
		$this->settings['zwe_use_addresses'] = new Setting('zwe_use_addresses', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, FALSE, true);
		$this->settings['zwe_use_canonicalphone'] = new Setting('zwe_use_canonicalphone', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, FALSE, true);
		$this->settings['zwe_use_birthyear'] = new Setting('zwe_use_birthyear', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, false, true);
		$this->settings['zwe_show_esvlogin_notice'] = new Setting('zwe_show_esvlogin_notice', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, true, true);
		$this->settings['zwe_use_background_queue'] = new Setting('zwe_use_background_queue', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, false, true);
		$this->settings['zwe_gdpr_enabled'] = new Setting('zwe_gdpr_enabled', Setting::TYPE_BOOLEAN, Setting::CATEGORY_SYSTEM, false, true);
		$this->settings['google_maps_apikey'] = new Setting('google_maps_apikey', Setting::TYPE_STRING, Setting::CATEGORY_SYSTEM, '', false);
		$this->settings['google_geocoding_apikey'] = new Setting('google_geocoding_apikey', Setting::TYPE_STRING, Setting::CATEGORY_SYSTEM, '', false);
		$this->settings['zwe_preset_availability'] = (new Setting('zwe_preset_availability', Setting::TYPE_OPTIONS, Setting::CATEGORY_MANDATOR, 'event', true))
			->setOptions(['1' => 'berücksichtigen', '0' => 'nicht berücksichtigen']);
		$this->settings['zwe_preset_mandator'] = (new Setting('zwe_preset_mandator', Setting::TYPE_OPTIONS, Setting::CATEGORY_MANDATOR, 'event', true))
			->setOptions(['event' => 'Veranstaltung', 'user' => 'ZWE (primär)', 'all' => 'alle verfügbaren']);
		$this->settings['zwe_preset_origin'] = (new Setting('zwe_preset_origin', Setting::TYPE_OPTIONS, Setting::CATEGORY_MANDATOR, 'int', true))
			->setOptions(['int' => 'intern', 'all' => 'alle', 'ext' => 'auswärtig']);
		$this->settings['zwe_datenschutz_kontakt'] = new Setting('zwe_datenschutz_kontakt', Setting::TYPE_TEXT, Setting::CATEGORY_SYSTEM,
			null, false);
		$this->settings['zwe_dashboard_all'] = new Setting('zwe_dashboard_all', Setting::TYPE_BOOLEAN, Setting::CATEGORY_MANDATOR, false, true);

		self::$instance = $this;
	}

	/**
	 * @return Setting[]
	 */
	public function getAllSettings()
	{
		return $this->settings;
	}

	/**
	 * @return Setting[]
	 */
	public function getAllMandatorSettings()
	{
		$settings = array();
		foreach ($this->settings as $s) {
			if ($s->getCategory() == Setting::CATEGORY_MANDATOR) {
				$settings[] = $s;
			}
		}
		return $settings;
	}

	/**
	 * @param $name
	 * @return Setting
	 * @throws SettingsException
	 */
	public function get($name)
	{
		return $this->findSetting($name);
	}

	private function findSetting($name)
	{
		foreach ($this->settings as $k => $v) {
			if ($k == $name) {
				return $v;
			}
		}
		throw new SettingsException('Die Einstellung ' . $name . ' existiert nicht!');
	}

	/**
	 * @return SettingsRegistry
	 */
	public static function getInstance()
	{
		if (self::$instance == null) {
			self::$instance == new SettingsRegistry();
		}
		return self::$instance;
	}

}