<?php
namespace ZWE\Repository;

class StartclassRepository extends AbstractRepository
{

	public function find($id)
	{
		return $this->findInternal('Startclass', $id);
	}

	/**
	 * @return array
	 */
	public function getAllNames($onlyEnabled = false)
	{
		$query = \Doctrine_Query::create()
			->select('s.id, s.name')
			->from('Startclass s')
			->orderBy('s.name')
			->setHydrationMode(\Doctrine::HYDRATE_ARRAY);
		if ($onlyEnabled) {
			$query->addWhere('s.enabled = ?', true);
		}
		return $this->toSingleDimension($query->execute(), 'id', 'name');
	}

	/**
	 * @param bool $onlyEnabled
	 * @return \Doctrine_Collection
	 */
	public function getAll($onlyEnabled = false)
	{
		$query = \Doctrine_Query::create()
			->select('s.*, c.*, l.*')
			->from('Startclass s')
			->leftJoin('s.Competitions c')
			->innerJoin('s.License l')
			->orderBy('s.name');
		if ($onlyEnabled) {
			$query->addWhere('s.enabled = ?', true);
		}
		return $query->execute();
	}

}
