<?php
namespace ZWE\Repository;

class QueryParam
{

	const WHERE = 1;

	private $type;
	private $field;
	private $operator;
	private $value;

	private function __construct($type, $field, $operator, $value)
	{
		$this->type = $type;
		$this->field = $field;
		$this->operator = $operator;
		$this->value = $value;
	}

	static function where($field, $operator, $value)
	{
		return new QueryParam(self::WHERE, $field, $operator, $value);
	}

	public function getField()
	{
		return $this->field;
	}

	public function getValue()
	{
		return $this->value;
	}

	public function getType()
	{
		return $this->type;
	}

	public function getOperator()
	{
		return $this->operator;
	}

}