<?php
namespace ZWE\Repository;

class DancetypeRepository extends AbstractRepository
{

	public function find($id)
	{
		return $this->findInternal('Dancetype', $id);
	}

	public function getAllNames()
	{
		$query = \Doctrine_Query::create()
			->select('d.id, d.name')
			->from('Dancetype d')
			->orderBy('d.name DESC')
			->setHydrationMode(\Doctrine::HYDRATE_ARRAY);
		return $this->toSingleDimension($query->execute(), 'id', 'name');
	}

}