<?php
namespace ZWE\Repository;

class CountryRepository extends AbstractRepository
{

	/**
	 * @return \Country[]
	 */
	public function all()
	{
		$countries = $this->queryWithParams();
		$ret = array();
		foreach ($countries as $c) {
			$ret[$c->id] = $c->name;
		}
		return $ret;
	}

	/**
	 * @param $id
	 * @return \Country
	 */
	public function find($id)
	{
		return $this->findInternal('Country', $id);
	}

	/**
	 * @param $alpha3
	 * @return \Country|null
	 */
	public function findByISOAlpha3($alpha3)
	{
		if (!$alpha3) {
			throw new \InvalidArgumentException('ISO Alpha3-Code erforderlich!');
		}
		$results = $this->queryWithParams($alpha3);
		if ($results != null) {
			return $results->getFirst();
		}
	}

	/**
	 * @return \Doctrine_Collection
	 */
	public function queryWithParams($alpha3 = null)
	{
		$query = \Doctrine_Query::create()
			->from('Country c')
			->orderBy('c.name');
		if ($alpha3 != null) {
			$query->addWhere('alpha3 = ?', trim(strtoupper($alpha3)));
		}
		return $query->execute();
	}

}
