<?php
namespace ZWE\Repository;

abstract class AbstractRepository
{

	protected function augmentDynamicQuery($query, $queryparams)
	{
		foreach ($queryparams as $queryparam) {
			if (!($queryparam instanceof QueryParam)) {
				throw new \RuntimeException("Filter array may only contain objects of type QueryParam!");
			}
			switch ($queryparam->getType()) {
				case QueryParam::WHERE:
					if ($queryparam->getValue() != NULL) {
						$query->andWhere("{$queryparam->getField()} {$queryparam->getOperator()} (?)", $queryparam->getValue());
					} else {
						$query->andWhere("{$queryparam->getField()} {$queryparam->getOperator()}");
					}
					break;
				default:
					throw new \RuntimeException("QueryParam with type {$queryparam->getType()} is not supported!");
			}
		}

	}

	public function delete($record)
	{
		$record->delete();
	}

	protected function findInternal($table, $id)
	{
		return \Doctrine::getTable($table)->find($id);
	}

	public function load($id)
	{
		// TODO: create abstract base function
		// @phpstan-ignore-next-line
		$ret = $this->find($id);
		if ($ret == NULL) {
			throw new ObjectNotFoundException('Objekt nicht gefunden.', \Doctrine::ERR_NOT_FOUND);
		}
		return $ret;
	}

	public function refresh($record, $refreshcomponents = FALSE)
	{
		return $record->refresh($refreshcomponents);
	}

	public function save($record, $refresh = FALSE, $refreshcomponents = FALSE)
	{
		$record->save();
		if ($refresh) {
			$this->refresh($record, $refreshcomponents);
		}
		return $record;
	}

	/**
	 * @param $input
	 * @param $idkey
	 * @param $valuekey
	 * @return array
	 */
	protected function toSingleDimension($input, $idkey, $valuekey)
	{
		$return = array();
		foreach ($input as $item) {
			$return[$item[$idkey]] = $item[$valuekey];
		}
		return $return;
	}

	/**
	 * Transformiert die Eingabe $ltvs in ein Array von LTV-IDs.
	 * @param $ltvs mixed
	 * @return array
	 */
	protected function landesverbaendeToIdArray($ltvs)
	{
		if ($ltvs == null) {
			return array();
		}
		$ids = array();
		if (is_a($ltvs, '\Doctrine_Collection')) {
			foreach ($ltvs as $ltv) {
				$ids[] = $ltv->id;
			}
		} elseif (is_array($ltvs)) {
			foreach ($ltvs as $ltv) {
				if (is_a($ltv, '\LTV')) {
					$ids[] = $ltv->id;
				} else {
					$ids[] = $ltv;
				}
			}
		} else {
			$ids[] = $ltvs;
		}
		return $ids;
	}
}
