<?php
namespace ZWE\Mandator;

class MandatorService
{

	public function allNames()
	{
		$mandators = $this->getMandators();
		$ret = array();
		foreach ($mandators as $m) {
			$ret[$m->id] = $m->name;
		}
		return $ret;
	}

	public function getMandators()
	{
		return \Doctrine_Query::create()
			->select('m.*')
			->from('Mandator m')
			->orderBy('m.name')
			->execute();
	}

	public function getMandator($id)
	{
		return \Doctrine_Query::create()
			->select('m.*, mg.*, o.*')
			->from('Mandator m')
			->leftJoin('m.MandatorGrants mg')
			->leftJoin('m.Operators o')
			->where('m.id = ?', $id)
			->fetchOne();
	}

	public function getAllPossibleOperators()
	{
		return \Doctrine_Query::create()
			->select('u.*, mg.*')
			->from('User u')
			->leftJoin('u.MandatorGrants mg')
			->innerJoin('u.Roles r')
			->where('r.role = ?', \Role::ZWE)
			->orderBy('u.surname, u.name, u.id')
			->execute();
	}

}