<?php
namespace ZWE\Mail\Template;

class Template
{
	/**
	 * @var string
	 */
	private $name;

	/**
	 * @var string
	 */
	private $templateHtml;

	/**
	 * @var bool
	 */
	private $loadFunctions;

	/**
	 * @var bool
	 */
	private $rendered = false;

	/**
	 * @var string
	 */
	private $contentHtml;

	/**
	 * @var string
	 */
	private $customTextHtml;

	public function __construct($name, $loadFunctions, $customTextHtml = null)
	{
		$this->name = $name;
		$this->templateHtml = $this->getFilenameHtml();
		$this->loadFunctions = $loadFunctions;
		$this->customTextHtml = $customTextHtml;

		$this->verify();
	}

	public function render(array $context)
	{
		if ($this->rendered) {
			throw new TemplateException("Template ist bereits gerendert!");
		}
		$this->contentHtml = $this->renderInternal($this->templateHtml, $context, $this->customTextHtml);
		$this->rendered = true;
	}

	public function getContentHtml()
	{
		$this->checkRendered();
		return $this->contentHtml;
	}

	private function checkRendered()
	{
		if (!$this->rendered) {
			throw new TemplateException("Template ist noch nicht gerendert!");
		}
	}

	private function renderInternal($template, array $context, $customText = null)
	{
		if($customText != null) {
			$context['__custom_text__'] = $customText;
		}
		extract($context);
		ob_start();
		if ($this->loadFunctions) {
			include_once $this->getFilenameFunctions();
		}
		include $template;
		$contents = ob_get_contents();
		ob_end_clean();
		return $contents;
	}

	private function verify()
	{
		$files = array($this->templateHtml);
		if ($this->loadFunctions) {
			$files[] = $this->getFilenameFunctions();
		}
		foreach ($files as $file) {
			clearstatcache(true, $file);
			if (!@is_file($file)) {
				throw new TemplateException("Datei {$file} existiert nicht!");
			}
			if (!@is_readable($file)) {
				throw new TemplateException("Datei {$file} kann nicht gelesen werden!");
			}
		}
	}

	private function getFilenameHtml()
	{
		return dirname(__FILE__) . '/files/' . $this->name . "_html.php";
	}

	private function getFilenameFunctions()
	{
		return dirname(__FILE__) . '/functions/functions.php';
	}
}