<?php

namespace ZWE\Jobs;

use Symfony\Component\Validator\Constraints as Assert;
use ZWE\FileStorage\File;

class SendAssignmentplanMailJob extends AbstractSendEventBasedMailJob
{

	/**
	 * @var File
	 * @Assert\NotNull()
	 */
	private $pdf;

	/**
	 * @var File
	 * @Assert\NotNull()
	 */
	private $zwex;

	/**
	 * @var mixed
	 */
	private $cc;

	/**
	 * @return File
	 */
	public function getPdf()
	{
		return $this->pdf;
	}

	/**
	 * @param File $pdf
	 * @return SendAssignmentplanMailJob
	 */
	public function setPdf(File $pdf)
	{
		$this->pdf = $pdf;
		return $this;
	}

	/**
	 * @return File
	 */
	public function getZwex()
	{
		return $this->zwex;
	}

	/**
	 * @param File $zwex
	 * @return SendAssignmentplanMailJob
	 */
	public function setZwex(File $zwex)
	{
		$this->zwex = $zwex;
		return $this;
	}

	/**
	 * @return mixed
	 */
	public function getCc()
	{
		return $this->cc;
	}

	/**
	 * @param mixed $cc
	 * @return SendAssignmentplanMailJob
	 */
	public function setCc($cc)
	{
		$this->cc = $cc;
		return $this;
	}

	protected function getValuesToSerialize()
	{
		return array_merge(parent::getValuesToSerialize(), [
			'pdf' => serialize($this->pdf),
			'zwex' => serialize($this->zwex),
			'cc' => $this->cc
		]);
	}

	protected function unserializeInternal($unserializedValues)
	{
		parent::unserializeInternal($unserializedValues);
		$this->pdf = unserialize($unserializedValues['pdf']);
		$this->zwex = unserialize($unserializedValues['zwex']);
		$this->cc = $unserializedValues['cc'];
	}

	public function run(callable $shouldInterrupt = null)
	{
		if ($this->container->getMailingService()->sendAssignmentplanMessage($this->messageId, $this->event, $this->pdf, $this->zwex, $this->cc, $shouldInterrupt)) {
			return true;
		} else {
			return false;
		}
	}
}
