<?php

namespace ZWE\Jobs;

use ZWE\Container\ZWEApplicationContainer;

class JobFactory
{

	/**
	 * @var ZWEApplicationContainer
	 */
	private $container;

	public function __construct(ZWEApplicationContainer $container)
	{
		$this->container = $container;
	}

	/**
	 * @return SendCustomMailJob
	 */
	public function createSendCustomMailJob()
	{
		return new SendCustomMailJob($this->container);
	}

	/**
	 * @return SendPasswordResetMailJob
	 */
	public function createSendPasswordResetMailJob()
	{
		return new SendPasswordResetMailJob($this->container);
	}

	/**
	 * @return SendUserActivatedMailJob
	 */
	public function createSendUserActivatedMailJob()
	{
		return new SendUserActivatedMailJob($this->container);
	}

	/**
	 * @return SendUserValidationMailJob
	 */
	public function createSendUserValidationMailJob()
	{
		return new SendUserValidationMailJob($this->container);
	}

	/**
	 * @return SendUserUnlockedMailJob
	 */
	public function createSendUserUnlockedMailJob()
	{
		return new SendUserUnlockedMailJob($this->container);
	}

	/**
	 * @return SendUserLoginChangedMailJob
	 */
	public function createSendUserLoginChangedMailJob()
	{
		return new SendUserLoginChangedMailJob($this->container);
	}

	/**
	 * @return SendInvitationMailJob
	 */
	public function createSendInvitationMailJob()
	{
		return new SendInvitationMailJob($this->container);
	}

	/**
	 * @return SendCancellationMailJob
	 */
	public function createSendCancellationMailJob()
	{
		return new SendCancellationMailJob($this->container);
	}

	/**
	 * @return SendAssignmentCancelledMailJob
	 */
	public function createSendAssignmentCancelledMailJob()
	{
		return new SendAssignmentCancelledMailJob($this->container);
	}

	/**
	 * @return SendAssignmentConfirmedMailJob
	 */
	public function createSendAssignmentConfirmedMailJob()
	{
		return new SendAssignmentConfirmedMailJob($this->container);
	}

	/**
	 * @return SendAssignmentDeletedMailJob
	 */
	public function createSendAssignmentDeletedMailJob()
	{
		return new SendAssignmentDeletedMailJob($this->container);
	}

	/**
	 * @return SendAssigmentReminderMailJob
	 */
	public function createSendReminderMailJob()
	{
		return new SendAssigmentReminderMailJob($this->container);
	}

	/**
	 * @return SendValidateNewEmailMailJob
	 */
	public function createSendValidateNewEmailJob()
	{
		return new SendValidateNewEmailMailJob($this->container);
	}

	/**
	 * @return SendEventCancelledMailJob
	 */
	public function createSendEventCancelledMailJob()
	{
		return new SendEventCancelledMailJob($this->container);
	}

	/**
	 * @return SendAssignmentplanMailJob
	 */
	public function createSendAssignmentplanMailJob()
	{
		return new SendAssignmentplanMailJob($this->container);
	}

	/**
	 * @return GdprDeleteUserJob
	 */
	public function createGdprDeleteUserJob()
	{
		return new GdprDeleteUserJob($this->container);
	}
}
