<?php

namespace ZWE\Jobs;

use Symfony\Component\Validator\Constraints as Assert;

abstract class AbstractSendUserBasedMailJob extends AbstractSendMailJob
{

	/**
	 * @var
	 * @Assert\NotNull()
	 */
	protected $user;

	/**
	 * @return mixed
	 */
	public function getUser()
	{
		return $this->user;
	}

	/**
	 * @param \User $user
	 * @return $this
	 */
	public function setUser(\User $user)
	{
		$this->user = $user;
		return $this;
	}

	protected function getValuesToSerialize()
	{
		return [
			'userId' => $this->user->id,
		];
	}

	protected function unserializeInternal($unserializedValues)
	{
		parent::unserializeInternal($unserializedValues);
		$this->user = \Doctrine::getTable(\User::class)->findOneBy('id', $unserializedValues['userId']);
	}
}
