<?php

namespace ZWE\Jobs;

use Symfony\Component\Validator\Constraints as Assert;
use ZWE\Container\ZWEApplicationContainer;
use ZWE\Container\ZWEApplicationContainerImpl;
use ZWE\Queue\Job;
use ZWE\UUID;

abstract class AbstractSendMailJob implements Job
{

	/**
	 * @var ZWEApplicationContainer
	 * @Assert\NotNull()
	 */
	protected $container;

	/**
	 * @var string
	 * @Assert\NotNull()
	 * @Assert\NotBlank()
	 */
	protected $messageId;

	public function __construct(ZWEApplicationContainer $container)
	{
		$this->container = $container;
		$this->messageId = UUID::randomUUID();
	}

	/**
	 * @return string
	 */
	public function getMessageId()
	{
		return $this->messageId;
	}

	public function getName()
	{
		return get_class($this);
	}

	public final function serialize()
	{
		$values = $this->getValuesToSerialize();
		if ($values) {
			return serialize(array_merge($values, ['messageId' => $this->messageId]));
		} else {
			return serialize(['messageId' => $this->messageId]);
		}
	}

	protected abstract function getValuesToSerialize();

	public final function unserialize($serialized)
	{
		$this->unserializeInternal(unserialize($serialized));
	}

	protected function unserializeInternal($unserializedValues)
	{
		$this->container = ZWEApplicationContainerImpl::getInstance();
		$this->messageId = $unserializedValues['messageId'];
	}
}
