<?php
namespace ZWE\Images;

use ZWE\FileStorage\File;

interface Image extends File
{

	/**
	 * @return int
	 */
	public function getWidth();

	/**
	 * @return int
	 */
	public function getHeight();

	/**
	 * @param $maxWidth
	 * @param $maxHeight
	 * @return array
	 */
	public function getScaledDimensions($maxWidth, $maxHeight);

	/**
	 * @param $maxWidth
	 * @param $maxHeight
	 * @return string
	 */
	public function getScaledDimensionsAsString($maxWidth, $maxHeight);

	/**
	 * @return array
	 */
	public function getDescriptor();

	/**
	 * @param $key
	 * @return mixed
	 */
	public function getDescriptorValue($key);
}