<?php
namespace ZWE\FileStorage;

interface FileStorage
{

	/**
	 * @param $relativePath
	 * @param $overwrite
	 * @return File
	 */
	public function create($relativePath, $overwrite = false);

	/**
	 * @param $relativePath
	 * @return bool
	 */
	public function exists($relativePath);

	/**
	 * @return File[]
	 */
	public function listFiles();

	/**
	 * @return File
	 */
	public function retrieve($relativePath);

}