<?php
namespace ZWE\Export\Freigaben;

use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use ZWE\Export\AbstractExcelExport;
use ZWE\Export\File;

class ExportFreigabenExcelImpl extends AbstractExcelExport implements ExportFreigabenExcel
{

	public function createDocument(\DateTime $from, \DateTime $to, $wrMandanten = null, $ltvs = null)
	{
		if ($this->created) {
			throw new \RuntimeException("Dokument ist bereits erstellt!");
		}

		$freigaben = $this->container->getAvailabilityRepo()->getAvailabilitiesBetween($from, $to, $wrMandanten, $ltvs);
		if ($freigaben->count() > 0) {
			$daten = array();
			foreach ($freigaben as $freigabe) {
				$datum = $freigabe->getDateTimeObject('datum')->format('d.m.Y');
				if (!isset($daten[$datum])) {
					$daten[$datum] = array();
				}
				$daten[$datum][] = $freigabe;
			}

			foreach ($daten as $datum => $records) {
				$sheet = new Worksheet($this->excel, $datum);
				$this->excel->addSheet($sheet);

				for ($col = 1; $col <= 8; $col++) {
					$sheet->getColumnDimensionByColumn($col, true)->setAutoSize(true);
				}

				$this->addHeaderCell($sheet, 1, 1, 'Name');
				$this->addHeaderCell($sheet, 2, 1, 'Vorname');
				$this->addHeaderCell($sheet, 3, 1, 'St');
				$this->addHeaderCell($sheet, 4, 1, 'Lat');
				$this->addHeaderCell($sheet, 5, 1, 'Verein');
				$this->addHeaderCell($sheet, 6, 1, 'LTV');
				$this->addHeaderCell($sheet, 7, 1, 'Mandant');
				$this->addHeaderCell($sheet, 8, 1, 'Bemerkungen');

				$row = 2;
				foreach ($records as $record) {
					$sheet->setCellValueByColumnAndRow(1, $row, $record->User->surname);
					$sheet->setCellValueByColumnAndRow(2, $row, $record->User->name);
					$sheet->setCellValueByColumnAndRow(3, $row, $record->User->LicenseStEffective->shortname);
					$sheet->setCellValueByColumnAndRow(4, $row, $record->User->LicenseLatEffective->shortname);
					$sheet->setCellValueByColumnAndRow(5, $row, $record->User->Club->name);
					$sheet->setCellValueByColumnAndRow(6, $row, $record->User->Club->LTV->id);
					$sheet->setCellValueByColumnAndRow(7, $row, $record->User->Club->Owner->name);
					$sheet->setCellValueByColumnAndRow(8, $row, $record->User->bemerkungen);
					$row++;
				}
			}
		} else {
			$sheet = new Worksheet($this->excel, 'leer');
			$this->excel->addSheet($sheet);

			$sheet->setCellValue('A1', 'keine Daten');
		}

		$this->excel->setActiveSheetIndex(0);

		$this->created = true;
	}

	private function addHeaderCell(Worksheet $sheet, $col, $row, $text)
	{
		$sheet->setCellValueByColumnAndRow($col, $row, $text);
		$sheet->getStyleByColumnAndRow($col, $row)->getFont()->setBold(true);
	}

	public function send($format = self::FORMAT_XLSX, $baseFilename = 'freigaben')
	{
		parent::send($format, $baseFilename);
	}

}
