<?php
namespace ZWE\Export\Einsatzplan;

use ZWE\FileStorage\File;

interface ExportEinsatzplanPDF
{

	/**
	 * Generiert den Einsatzplan als PDF-Datei.
	 *
	 * @param \Event $event
	 * @param null $bemerkungen
	 * @return void
	 */
	public function generate(\Event $event, $bemerkungen = null);

	/**
	 * Speichert die generierte PDF-Datei im Dateisystem.
	 *
	 * @param File $file
	 * @return void
	 */
	public function saveAs(File $file);

	/**
	 * Sendet die generierte PDF-Datei mit Content-disposition: attachment.
	 * @return void
	 */
	public function send();

	/**
	 * Zeigt die generierte PDF-Datei mit Content-disposition: inline.
	 * @return void
	 */
	public function view();
} 