<?php
namespace ZWE\ESV\ExportFormat\Model;

use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\Expose;

class ZEFClubModel {

	/**
	 * @var string
	 * @Expose
	 * @Type("string")
	 */
	private $name;

	/**
	 * @var string
	 * @Expose
	 * @Type("string")
	 */
	private $ltv;

	public function __construct(\Club $club) {
		$this->name = $club->name;
		if($club->LTV != null && $club->LTV->isESV()) {
			$this->ltv = $club->LTV->esv_key;
		}
		else {
			$this->ltv = null;
		}
	}
}