<?php
namespace ZWE\ESV\ExportFormat;

use ZWE\ESV\ESVService;
use ZWE\FileStorage\File;
use ZWE\FileStorage\FileStorage;

class ExportZWEX
{

	/**
	 * @var FileStorage
	 */
	private $storage;

	/**
	 * @var ESVService
	 */
	private $esvService;

	/**
	 * @var \Event
	 */
	private $event;

	/**
	 * @var string
	 */
	private $export;

	public function __construct(FileStorage $storage, ESVService $esvService)
	{
		$this->storage = $storage;
		$this->esvService = $esvService;
	}

	public function generate(\Event $event)
	{
		$this->event = $event;
		$this->export = $this->esvService->exportLadenUndKonvertieren([$event->id]);
	}

	public function saveAs(File $file)
	{
		$file->write($this->export);
	}
}