<?php
namespace ZWE\ESV;

use Tanzsport\ESV\API\Model\Club;

class ESVReportVerein
{

	/**
	 * @var \Club
	 */
	private $verein;

	/**
	 * @var bool
	 */
	private $ausgeben = false;

	/**
	 * @var ESVAbweichung[]
	 */
	private $abweichungen = [];


	public function __construct(\Club $zweVerein, Club $esvVerein, $normalisieren = false)
	{
		$this->verein = $zweVerein;

		if ($normalisieren) {
			if ($this->normalisieren($zweVerein->name) != $this->normalisieren($esvVerein->name)) {
				$this->ausgeben = true;
				$this->abweichungen[] = new ESVAbweichung('verein_nname', $this->normalisieren($zweVerein->name), $this->normalisieren($esvVerein->name), true);
			}
		} else {
			if ($zweVerein->name != $esvVerein->name) {
				$this->ausgeben = true;
				$this->abweichungen[] = new ESVAbweichung('verein_name', $zweVerein->name, $esvVerein->name, true);
			}
		}

		if ($zweVerein->LTV->esv_key != $esvVerein->ltv->name) {
			$this->ausgeben = true;
			$this->abweichungen[] = new ESVAbweichung('verein_ltv', $zweVerein->LTV->esv_key, $esvVerein->ltv->name, true);
		}
	}

	private function normalisieren($input)
	{
		return trim(preg_replace('/e\.\s?v\.$|e\.\s?v\.,? |ev$/i', '', $input));
	}

	/**
	 * @return bool
	 */
	public function isAusgeben()
	{
		return $this->ausgeben;
	}

	/**
	 * @return ESVAbweichung[]
	 */
	public function getAbweichungen()
	{
		return $this->abweichungen;
	}

	/**
	 * @return \Club
	 */
	public function getVerein()
	{
		return $this->verein;
	}
}