<?php
namespace ZWE\ESV;

class ESVAbweichung
{

	private $feld;
	private $alterWert;
	private $alterWertAnzeige;
	private $neuerWert;
	private $neuerWertAnzeige;
	private $autoKorrigierbar;

	private static $beschreibungen = [
		'verein_name' => 'Vereinsname',
		'verein_nname' => 'Vereinsname (normalisiert)',
		'verein_ltv' => 'LTV (ESV-Schlüssel)',
		'person_vorname' => 'Vorname',
		'person_nachname' => 'Nachname',
		'person_titel' => 'Titel',
		'person_vnum' => 'Verein',
		'person_status' => 'Status',
		'person_lstd' => 'Lizenz Standard',
		'person_llat' => 'Lizenz Latein',
		'person_leinschraenkung' => 'Startklassen-Einschränkung',
	];

	public function __construct($feld, $alterWert, $neuerWert, $autoKorrektur = false, $alterWertAnzeige = null, $neuerWertAnzeige = null)
	{
		$this->feld = $feld;
		$this->alterWert = $alterWert;
		$this->neuerWert = $neuerWert;
		$this->autoKorrigierbar = $autoKorrektur;
		$this->alterWertAnzeige = $alterWertAnzeige;
		$this->neuerWertAnzeige = $neuerWertAnzeige;
	}

	public function getFeld()
	{
		return $this->feld;
	}

	public function getBeschreibung()
	{
		if (isset(self::$beschreibungen[$this->feld])) {
			return self::$beschreibungen[$this->feld];
		}
		return $this->feld;
	}

	public function getAlterWert()
	{
		return $this->alterWert;
	}

	public function getAlterWertAnzeige()
	{
		if ($this->alterWertAnzeige) {
			return $this->alterWertAnzeige;
		}
		return $this->alterWert;
	}

	public function getNeuerWert()
	{
		return $this->neuerWert;
	}

	public function getNeuerWertAnzeige()
	{
		if ($this->neuerWertAnzeige) {
			return $this->neuerWertAnzeige;
		}
		return $this->neuerWert;
	}

	public function isAutoKorrigierbar()
	{
		return $this->autoKorrigierbar;
	}
}