<?php
namespace ZWE\ESV;

class DTVNummerGenerator
{

	/**
	 * @param $praefix
	 * @param $start
	 * @return DTVNummer
	 */
	public function naechsteNummerGenerieren($praefix, $start)
	{
		if (!$praefix) {
			throw new \InvalidArgumentException('Präfix erforderlich!');
		}
		if (strlen(trim($praefix)) != 2) {
			throw new \InvalidArgumentException('Präfix muss zwei Zeichen lang sein!');
		}
		if (strtoupper(trim($praefix)) == 'DE') {
			throw new \InvalidArgumentException('DTV-Nummern für das Präfix DE können nicht generiert werden!');
		}
		if ($start < 1) {
			throw new \InvalidArgumentException('Startwert muss größer 0 sein!');
		}

		$sequenz = $this->findOrCreateSequenz($praefix);
		if (!$sequenz->letzte_nummer) {
			$sequenz->letzte_nummer = $start;
		} else {
			$sequenz->letzte_nummer++;
		}
		$sequenz->save();

		return DTVNummer::create($praefix, $sequenz->letzte_nummer);
	}

	/**
	 * @param $praefix
	 * @return \DTVNummerSequenz
	 */
	private function findOrCreateSequenz($praefix)
	{
		$sequenz = \Doctrine::getTable('DTVNummerSequenz')->findOneBy('praefix', trim(strtoupper($praefix)));
		if (!$sequenz) {
			$sequenz = new \DTVNummerSequenz();
			$sequenz->praefix = strtoupper(trim($praefix));
		}
		return $sequenz;
	}

}