<?php

namespace ZWE\Context;

/**
 * Interface für die Implementierung eines ContextHolder, in dem
 * eine Kontext-Variable gespeichert werden kann.
 *
 * @author  Hendrik Heneke <hendrik@pixelwunder.net>
 * @since   2.5
 */
interface ContextHolder {

    /**
     * Speichert die Kontext-Variable.
     *
     * @param mixed Kontext-Variable
     */
    public function setContext($contextVar);

    /**
     * Gibt die aktuelle Kontext-Variable zurück.
     *
     * @return mixed
     */
    public function getContext();

    /**
     * Löscht die Kontext-Variable.
     */
    public function clearContext();

}
