<?php
namespace ZWE\Container;

class TestConfigurationSourceImpl implements ZWEConfigurationSource
{
	private $config = array();

	public function __construct()
	{
		$this->config['zwe.workspace'] = dirname(__FILE__) . '/../../../../workspace';
		$this->config['log_path'] = dirname(__FILE__) . '/../../../../workspace/logs';
		$this->config['log_threshold'] = 4;
	}

	public function offsetExists($offset)
	{
		return isset($this->config[$offset]);
	}

	public function offsetGet($offset)
	{
		return $this->config[$offset];
	}

	public function offsetSet($offset, $value)
	{
		$this->config[$offset] = $value;
	}

	public function offsetUnset($offset)
	{
		unset($this->config[$offset]);
	}

}