<?php
namespace ZWE\Calendar;

class CalendarSheetIterator implements \Iterator
{

	private $start;
	private $current;
	private $max;
	private $year;
	private $month;

	private $index = 0;
	private $days = array();

	private $user;
	private $availabilities;
	private $assignments;

	public function __construct($year, $month, $user = null, $availabilities = null, $assignments = null)
	{
		$this->start = mktime(0, 0, 0, $month, 1, $year);
		$this->year = $year;
		$this->month = $month;

		// start berechnen (vorheriger montag)
		$start_localtime = localtime($this->start, true);
		$this->start -= ($start_localtime['tm_wday'] == 0) ? (6 * 86400) : ($start_localtime['tm_wday'] - 1) * 86400;
		// current auf start initialisieren
		$this->current = $this->start;

		// max berechnen
		$this->max = mktime(0, 0, 0, $month + 1, 1, $year);
		$max_localtime = localtime($this->max, true);
		$this->max += ($max_localtime['tm_wday'] != 1) ? (8 - $max_localtime['tm_wday']) * 86400 : 0;

		$this->availabilities = $availabilities;
		$this->assignments = $assignments;
		$this->user = $user;
	}

	public function current()
	{
		if (!isset($this->days[$this->index])) {
			$availability = null;
			$assignments = null;
			if (isset($this->assignments[$this->current])) {
				$assignments = $this->assignments[$this->current];
			}
			if (isset($this->availabilities[$this->current])) {
				$availability = $this->availabilities[$this->current];
			}
			$this->days[$this->index] = new CalendarDay($this->current, $this->year, $this->month, $this->user, $availability, $assignments);
		}
		return $this->days[$this->index];
	}

	public function key()
	{
		return $this->index;
	}

	public function next()
	{
		$this->index++;
		$this->current += $this->getOffsetForNextDay();
	}

	public function rewind()
	{
		$this->index = 0;
		$this->current = $this->start;
	}

	public function valid()
	{
		return $this->current < $this->max;
	}

	private function getOffsetForNextDay()
	{
		// wenn letzter tag sommerzeit und aktueller tag winterzeit 25 stunden addieren
		if ($this->isDST($this->current) && !$this->isDST($this->current + 86400)) {
			return 86400 + 3600;
		} // wenn letzer tag winterzeit und aktueller tag sommerzeit 23 stunden addieren
		elseif (!$this->isDST($this->current) && $this->isDST($this->current + 86400)) {
			return 86400 - 3600;
		} // sonst 24 stunden addieren
		else {
			return 86400;
		}
	}

	private function isDST($timestamp)
	{
		$localtime = localtime($timestamp, true);
		return $localtime['tm_isdst'] == 1;
	}

}
