<?php

abstract class AbstractDoctrineTestSuite extends PHPUnit_Framework_TestSuite
{

	/**
	 * @var DoctrineInitializer
	 */
	private $di;

	protected function setUp()
	{
		if ($this->getDatabaseDSN() != null) {
			$this->di = new DoctrineInitializer($this->getDatabaseDSN(), $this->getModelDirectories());
			if ($this->isConnectToDatabase()) {
				$this->di->connect();

				if ($this->isDropCreateDatabase()) {
					$this->di->dropCreateDatabase();
				}

				if ($this->isCreateStructure()) {
					if ($this->isUseMigrations()) {
						$this->di->createStructureFromMigrations($this->getMigrationsDirectory());
					} else {
						$this->di->createStructureFromModels();
					}
				}

				if ($this->getFixturesDirectory() !== null) {
					$this->di->loadFixtures($this->getFixturesDirectory());
				}
			}
		}
		parent::setUp();
	}

	protected function tearDown()
	{
		if ($this->di != null) {
			if ($this->isConnectToDatabase()) {
				$this->di->disconnect();
			}
		}
		parent::tearDown();
	}

	protected abstract function getDatabaseDSN();

	protected function getFixturesDirectory()
	{
		return null;
	}

	protected function getMigrationsDirectory()
	{
		return null;
	}

	protected abstract function getModelDirectories();

	protected function isConnectToDatabase()
	{
		return true;
	}

	protected function isCreateStructure()
	{
		return true;
	}

	protected function isDropCreateDatabase()
	{
		return true;
	}

	protected function isUseMigrations()
	{
		return false;
	}
}