<?php

namespace LTVBerlin\Contao\LTVBerlinBundle\Model;

class ErgebnisModel extends \Model
{

	/**
	 * Table name
	 *
	 * @var string
	 */
	protected static $strTable = 'tl_verband_ergebnis';

	private $arrResultFiles = null;

	private $topTurnierSearch = array(
		'Kin.',
		'Kin.I',
		'Kin.II',
		'Jun.I',
		'Jun.II',
		'Hgr.',
		'Hgr.II',
		'Sen.I',
		'Sen.II',
		'Sen.III',
		'Sen.IV',
		'Sen.V',
	);
	private $topTurnierReplace = array(
		'Kinder I/II',
		'Kinder I',
		'Kinder II',
		'Junioren I',
		'Junioren II',
		'Hauptgruppe',
		'Hauptgruppe II',
		'Senioren I',
		'Senioren II',
		'Senioren III',
		'Senioren IV',
		'Senioren V',
	);

	public static function findByJahr($strJahr)
	{
		if (!$strJahr) {
			$strJahr = date('Y');
		}

		$objDate = new \Date($strJahr, 'Y');
		$intBegin = $objDate->yearBegin;
		$intEnd = $objDate->yearEnd;

		return static::findByDate($intBegin, $intEnd);
	}

	private static function findByDate($intFrom, $intTo)
	{
		$t = static::$strTable;
		$arrColumns = array("$t.datumAnfang >= ? AND $t.datumAnfang <= ?");
		$arrOptions = array('order' => "$t.datumAnfang DESC, $t.titel ASC");
		return static::findBy($arrColumns, array($intFrom, $intTo), $arrOptions);
	}

	public function getAnchor()
	{
		return "erg{$this->id}";
	}

	public function getDateien()
	{
		if ($this->arrResultFiles !== null) {
			return new \ArrayIterator($this->arrResultFiles);
		}

		$this->arrResultFiles = array();

		$arrScannedFiles = $this->scanFiles();

		foreach ($arrScannedFiles as $scannedFile) {
			$arrMeta = deserialize($scannedFile->meta);
			if ($scannedFile->found && isset($arrMeta['de']['title'])) {
				$resultFile = new \stdClass();
				$resultFile->titel = $arrMeta['de']['title'];
				$resultFile->pfad = $scannedFile->path;
				$resultFile->name = $scannedFile->name;
				$resultFile->contaoObject = $scannedFile;
				$this->arrResultFiles[] = $resultFile;
			}
		}

		usort($this->arrResultFiles, array($this, 'sortFilesPfad'));

		return new \ArrayIterator($this->arrResultFiles);
	}

	public function getDatum()
	{
		$objAnfang = new \Date($this->datumAnfang);
		$strDatum = $objAnfang->date;
		if ($this->datumEnde != '') {
			$objEnde = new \Date($this->datumEnde);
			$strDatum .= ' - ' . $objEnde->date;
		}
		return $strDatum;
	}

	public function getJahr()
	{
		return \Date::parse('Y', $this->datumAnfang);
	}

	private function getFullPath(\FilesModel $objFile)
	{
		if (!$objFile) {
			return;
		}
		return TL_ROOT . '/' . $objFile->path;
	}

	private function parseFile(\FilesModel $objFile)
	{
		$arrMeta = deserialize($objFile->meta, true);
		$blnMetaSet = isset($arrMeta["de"]["title"]) && $arrMeta["de"]["title"] != '';

		$strPath = $this->getFullPath($objFile);
		if (file_exists($strPath)) {
			try {
				$objDom = new \DOMDocument();
				@$objDom->loadHTMLFile($strPath);
				$objXpath = new \DOMXPath($objDom);

				$mode = 'generic';

				// try to determine generator
				$objMeta = $objXpath->query("//html/head/meta[@name='generator']/@content");
				if ($objMeta->length == 0) {
					$objMeta = $objXpath->query("//html/head/meta[@name='Generator']/@content");
				}
				if($ojMeta->length == 0) {
					$objMeta = $objXpath->query("//html/head/meta[@name='GENERATOR']/@content");
				}
				if ($objMeta->length) {
					$strGenerator = $objMeta->item(0)->nodeValue;
					if (preg_match('/caos/i', $strGenerator)) {
						$mode = 'caos';
					} elseif (preg_match('/turnier protokoll system/i', $strGenerator)) {
						$mode = 'tps';
					} elseif (preg_match('/topturnier/i', $strGenerator)) {
						$mode = 'topturnier';
					}
				}
				if ($mode != null) {
					$strTitle = null;
					// try to read title tag
					$objTitles = $objXpath->query("//html/head/title");
					if ($objTitles->length) {
						$strTitle = $objTitles->item(0)->nodeValue;
					}

					$blnExclude = false;

					if ($strTitle) {
						switch ($mode) {
							case 'caos':
								$strPattern = "/^Ergebnis\s(.+)\s\d{2}\.\d{2}.\d{4}$/";
								if (preg_match($strPattern, $strTitle)) {
									$strTitle = preg_replace($strPattern, "$1", $strTitle);
								}
								break;
							case 'tps':
								$strPattern = "/^(.+)\s\(.+\)$/";
								if (preg_match($strPattern, $strTitle)) {
									$strTitle = preg_replace($strPattern, "$1", $strTitle);
								}
								break;
							case 'topturnier':
								$strPattern = "/^\d{2}\.\d{2}.\d{4}\s/";
								if (preg_match($strPattern, $strTitle)) {
									$strTitle = preg_replace($strPattern, "$1", $strTitle);
									if(strpos($strTitle, '.') !== false) {
										$strTitle = str_replace($this->topTurnierSearch, $this->topTurnierReplace, $strTitle);
									}
								}
								$blnExclude = $objXpath->query("//html/frameset")->length == 0;
								break;
							case 'generic':
							default:
								break;
						}

						$objResult = new \stdClass();
						$objResult->file = $objFile->path;
						$objResult->title = $strTitle;
						$objResult->modified = false;

						if(!$blnExclude) {
							if (!$blnMetaSet) {
								$arrMeta["de"]["title"] = $strTitle;
								$objFile->meta = serialize($arrMeta);
								$objFile->save();
								$objResult->modified = true;
							}
						}

						return $objResult;
					}

				}
			} catch (\Exception $ex) {
				return;
			}
		}
	}

	public function parseFiles()
	{
		$arrParsed = array();

		$arrScanned = $this->scanFiles(true);
		foreach ($arrScanned as $objFile) {
			$result = $this->parseFile($objFile);
			if ($result) {
				$arrParsed[] = $result;
			}
		}

		return $arrParsed;
	}

	private function resetFile(\FilesModel $objFile)
	{
		$arrMeta = deserialize($objFile->meta, true);
		$blnMetaSet = isset($arrMeta["de"]["title"]) && $arrMeta["de"]["title"] != '';

		$objResult = new \stdClass();

		$objResult->file = $objFile->path;
		$objResult->modified = false;

		if ($blnMetaSet) {
			unset($arrMeta["de"]["title"]);
			$objFile->meta = serialize($arrMeta);
			$objFile->save();
			$objResult->modified = true;
		}

		return $objResult;
	}

	public function resetFiles()
	{
		$arrReset = array();

		$arrScanned = $this->scanFiles();
		foreach ($arrScanned as $objFile) {
			$result = $this->resetFile($objFile);
			if ($result) {
				$arrReset[] = $result;
			}
		}

		return $arrReset;
	}

	private function scanFiles($blnCheckSublevelFilenames = false)
	{
		$arrFiles = array();

		$objFiles = $this->getRelated('multiSRC');
		if($objFiles != null) {
			while ($objFiles->next()) {
				$objFile = $objFiles->current();
				if ($objFile->found) {
					if ($objFile->type == 'file') {
						if ($this->isResultFile($objFile, false)) {
							$arrFiles[] = $objFile;
						}
					} else if ($objFile->type == 'folder') {
						$arrFiles = array_merge($arrFiles, $this->scanFolder($objFile, 1, $blnCheckSublevelFilenames));
					}
				}
			}
		}

		return $arrFiles;
	}

	private function scanFolder(\FilesModel $objFolder, $intLevel = 1, $blnCheckFilename = false)
	{
		$arrFiles = array();
		if ($intLevel > 2) {
			return $arrFiles;
		}

		$objFiles = \FilesModel::findMultipleByBasepath($objFolder->path);
		if ($objFiles != null) {
			while ($objFiles->next()) {
				$objFile = $objFiles->current();
				if ($objFile->type == 'file') {
					if ($this->isResultFile($objFile, $blnCheckFilename)) {
						$arrFiles[] = $objFile;
					}
				}
			}
		}

		return $arrFiles;
	}

	private function isResultFile(\FilesModel $objFile, $blnCheckFilename = true)
	{
		if ($objFile->type == 'folder') {
			return false;
		}
		if (!in_array($objFile->extension, array('htm', 'html', 'HTM', 'HTML'))) {
			return false;
		}
		if (!$blnCheckFilename) {
			return true;
		}
		if (preg_match("/index\.html?/i", $objFile->name)) {
			return true;
		}
		if (preg_match("/\d+\w+\.html?/i", $objFile->name)) {
			return true;
		}
		return false;
	}

	public function sortFilesPfad(\stdClass $a, \stdClass $b)
	{
		return strcmp($a->pfad, $b->pfad);
	}

}
