<?php

Namespace LTVBerlin;

class Themes
{

    private static $manifest;

    static function assetUrl($name)
    {
        if (!self::$manifest) {
            self::$manifest = self::load();
        }
        if (!isset(self::$manifest->$name)) {
            throw new \RuntimeException("Asset {$name} is not defined in manifest!");
        }
        return self::$manifest->$name;
    }

    private static function load()
    {
        return self::fromFile('themes/manifest.json');
    }

    private static function fromFile($file)
    {
        $path = TL_ROOT . '/files/' . $file;
        if (!file_exists($path)) {
            throw new \RuntimeException("Theme manifest {$path} does not exist!");
        }
        $content = @json_decode(file_get_contents($path));
        if (json_last_error()) {
            throw new \RuntimeException("Could not read theme manifest: " . json_last_error_msg());
        }
        return $content;
    }
}
