<?php

namespace LTVBerlin;

class Categories
{
    static function titles(\FrontendTemplate $template, $default = 'Aktuell'): array
    {
        $categories = $template->categories;
        if (is_array($categories) && count($categories) > 0) {
            $titles = array_unique(array_map(function ($cat) {
                return $cat['frontendTitle'];
            }, $categories));
            return count($titles) > 5 ? [$default] : $titles;
        } else {
            return [$default];
        }
    }
}
