<?php
declare(strict_types=1);

namespace LTVBerlin\Contao\LTVBerlinBundle\Model;

use Contao\FilesModel;

class BelegungsplanModel
{
    public FilesModel $objFile;
    public string $year;
    public string $weekNumber;

    /**
     * @var false|string
     */
    private $realpath;

    public function __construct(FilesModel $model, string $year, string $weekNumber)
    {
        if (!$model->found) {
            throw new \LogicException('Cannot create model from non-existing file!');
        }

        $this->objFile = $model;
        $this->year = $year;
        $this->weekNumber = $weekNumber;
        $this->realpath = realpath(TL_ROOT . '/' . $model->path);
        if ($this->realpath) {
            clearstatcache(true, $this->realpath);
        }
    }

    public function getEnd()
    {
        return date("d.m.Y", $this->getEndTimestamp());
    }

    public function getStart()
    {
        return date("d.m.Y", $this->getStartTimestamp());
    }

    public function getUpdated()
    {
        return date("d.m.Y H:i", $this->getUpdatedTimestamp());
    }

    private function getEndTimestamp()
    {
        return strtotime("{$this->year}W{$this->weekNumber} + 6 days");
    }

    private function getStartTimestamp()
    {
        return strtotime("{$this->year}W{$this->weekNumber}");
    }

    private function getUpdatedTimestamp()
    {
        return filemtime($this->realpath);
    }
}
