<?php
declare(strict_types=1);

namespace LTVBerlin\Contao\LTVBerlinBundle\Controller\FrontendModule;

use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("ltvberlin_llz_raumbelegung",
 *     category="ltvberlin",
 *     template="mod_ltvberlin_llz_raumbelegung",
 *     renderer="forward"
 * )
 */
class LLZRaumbelegungFrontendModuleController extends AbstractLLZFrontendModuleController
{
    public function __construct()
    {
        parent::__construct();
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $template->plans = $this->findPlans($model->multiSRC);
        return $template->getResponse();
    }
}
