<?php

/**
 * Contao Extension LTVBerlin
 *
 * Copyright (c) 2013-2014 Hendrik Heneke <hendrik@pixelwunder.net>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 */

namespace LTVBerlin;

class ModuleSambaBackend extends \BackendModule
{

	/**
	 * @var string
	 */
	protected $strTemplate = 'mod_samba_backend';

	/**
	 * @var \Database
	 */
	private $db;

	public function __construct() {
		parent::__construct();
		$this->db = \Database::getInstance();
	}

	public function generate()
	{
		return parent::generate();
	}

	protected function compile()
	{
		if (\Input::post('samba_upload') == 1) {
			if(isset($GLOBALS["_FILES"]["samba"])) {
				$up = $GLOBALS["_FILES"]["samba"];

				$errMsg = null;
				switch($up["error"]) {
					case 0:
						break;
					case 1:
					case 2:
						$errMsg = "Hochgeladene Datei ist zu groß!";
						break;
					case 3:
						$errMsg = "Datei wurde noch teilweise hochgeladen!";
						break;
					case 4:
						$errMsg = "Keine Datei hochgeladen!";
						break;
					case 6:
						$errMsg = "Kein temporäres Verzeichnis für Uploads konfiguriert!";
						break;
					case 7:
						$errMsg = "Hochgeladene Datei konnte nicht gespeichert werden!";
						break;
					case 8:
						$errMsg = "Upload wurde gestoppt!";
						break;
				}

				if($errMsg) {
					\Message::addError($errMsg);
				}
				else {
					$this->loadXml($up["tmp_name"]);
					unlink($up["tmp_name"]);
				}
			}
		}

		$this->Template->messages = \Message::generate();
		$this->Template->href = $this->getReferer(true);
		$this->Template->title = specialchars($GLOBALS['TL_LANG']['MSC']['backBTTitle']);
		$this->Template->button = $GLOBALS['TL_LANG']['MSC']['backBT'];
		$this->Template->action = ampersand(\Environment::get('request'));
		$this->Template->submitButton = specialchars($GLOBALS['TL_LANG']['MSC']['continue']);

		\Message::reset();
	}

	private function loadXml($file) {
		$doc = new \DOMDocument();
		if($doc->load($file) !== false) {
			$xpath = new \DOMXPath($doc);

			$this->db->prepare("TRUNCATE TABLE tl_samba_lizenzzeitraum")->execute();
			foreach($xpath->query("//Lizenzzeitraum/Zeitraum") as $zeitraum) {
				$this->db->prepare("REPLACE INTO tl_samba_lizenzzeitraum (lzrID, lzrName) VALUES (?, ?)")->execute(array($zeitraum->attributes->getNamedItem("id")->nodeValue, $zeitraum->nodeValue));
			}

			$this->db->prepare("TRUNCATE TABLE tl_samba_lizenzart")->execute();
			foreach($xpath->query("//Lizenzart/Lizenz") as $lizenz) {
				$this->db->prepare("REPLACE INTO tl_samba_lizenzart (lzaID, lzaName) VALUES (?, ?)")->execute(array($lizenz->attributes->getNamedItem("id")->nodeValue, $lizenz->nodeValue));
			}

			$this->db->prepare("TRUNCATE TABLE tl_samba_ltv")->execute();
			foreach($xpath->query("//LTVLIST/LTV") as $ltv) {
				$this->db->prepare("REPLACE INTO tl_samba_ltv (ltvID, ltvName) VALUES (?, ?)")->execute(array($ltv->attributes->getNamedItem("id")->nodeValue, $ltv->nodeValue));
			}

			$this->db->prepare("TRUNCATE TABLE tl_samba_schulungsart")->execute();
			foreach($xpath->query("//Schulungsart/Schulung") as $schulung) {
				$this->db->prepare("REPLACE INTO tl_samba_schulungsart (slaID, slaName) VALUES (?, ?)")->execute(array($schulung->attributes->getNamedItem("id")->nodeValue, $schulung->nodeValue));
			}

			$this->db->prepare("TRUNCATE TABLE tl_samba_lizenzerhalt")->execute();
			foreach($xpath->query("//Lizenzerhalt/Erhalt") as $erhalt) {
				$values = new \stdClass();
				for($i = 0; $i < $erhalt->childNodes->length; $i++) {
					$child = $erhalt->childNodes->item($i);
					$prop = $child->nodeName;
					$values->$prop = $child->nodeValue;
				}
				$this->db->prepare("REPLACE INTO tl_samba_lizenzerhalt (perID, lzeDatum, lzaID, slgID, ltvID, lzeAnzahlUE, lzrID) VALUES (?, ?, ?, ?, ?, ?, ?)")->execute(array($values->perID, $values->lzeDatum, $values->lzaID, $values->slgID, $values->ltvID, $values->lzeAnzahlUE, $values->lzrID));
			}

			\Message::addConfirmation("Lizenzerhaltsdaten importiert.");
		}
		else {
			\Message::addError("XML konnte nicht gelesen werden.");
		}
	}
}