<?php

use LTVBerlin\Contao\LTVBerlinBundle\Model\ErgebnisModel;
use Contao\Input;
use Contao\Message;

$GLOBALS['TL_DCA']['tl_verband_ergebnis'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 1,
            'fields' => array('datumAnfang'),
            'flag' => 6,
            'panelLayout' => 'filter;sort,search,limit'
        ),
        'label' => array
        (
            'fields' => array('titel'),
            'format' => '%s'
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.gif'
            ),
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.gif',
                'attributes' => 'onclick="if (!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\')) return false; Backend.getScrollOffset();"'
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['show'],
                'href' => 'act=show',
                'icon' => 'show.gif'
            ),
        )
    ),

    // Edit
    'edit' => array
    (
        'buttons_callback' => array
        (
            array('tl_verband_ergebnis', 'addParseSingleButton'),
            array('tl_verband_ergebnis', 'addResetSingleButton')
        )
    ),

    // Select
    'select' => array
    (
        'buttons_callback' => array
        (
            array('tl_verband_ergebnis', 'addParseMultiButton'),
            array('tl_verband_ergebnis', 'addResetMultiButton')
        )
    ),

    // Palettes
    'palettes' => array
    (
        '__selector__' => array(''),
        'default' => '{ergebnis_legende},titel,datumAnfang,datumEnde;{dateien_legende},multiSRC'
    ),

    // Subpalettes
    'subpalettes' => array
    (
        '' => ''
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        'titel' => array
        (
            'sql' => "varchar(128) NOT NULL default ''",
            'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['titel'],
            'explanation' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['titel'],
            'exclude' => false,
            'inputType' => 'text',
            'search' => true,
            'sorting' => true,
            'eval' => array('mandatory' => true, 'minlength' => 1, 'maxlength' => 128, 'tl_class' => 'w100')
        ),
        'datumAnfang' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['datumAnfang'],
            'default' => null,
            'exclude' => true,
            'inputType' => 'text',
            'sorting' => true,
            'eval' => array('rgxp' => 'date', 'mandatory' => true, 'doNotCopy' => true, 'datepicker' => true, 'tl_class' => 'w50 wizard'),
            'sql' => "int(10) unsigned NULL"
        ),
        'datumEnde' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['datumEnde'],
            'default' => null,
            'exclude' => true,
            'inputType' => 'text',
            'eval' => array('rgxp' => 'date', 'doNotCopy' => true, 'datepicker' => true, 'tl_class' => 'w50 wizard'),
            'save_callback' => array
            (
                array('tl_verband_ergebnis', 'setEmptyEndDate')
            ),
            'sql' => "int(10) unsigned NULL"
        ),
        'multiSRC' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['multiSRC'],
            'exclude' => true,
            'inputType' => 'fileTree',
            'eval' => array('multiple' => true, 'fieldType' => 'checkbox', 'orderField' => 'orderSRC', 'files' => true, 'mandatory' => true),
            'sql' => "blob NULL",
            'foreignKey' => 'tl_files.uuid',
            'relation' => array('type' => 'hasMany', 'load' => 'eager', 'field' => 'uuid'),
        ),
        'orderSRC' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_verband_ergebnis']['orderSRC'],
            'sql' => "blob NULL"
        ),
    )
);

class tl_verband_ergebnis extends Backend
{

    public function __construct()
    {
        parent::__construct();
        $this->import('BackendUser', 'User');
    }

    public function setEmptyEndDate($varValue)
    {
        if ($varValue === '') {
            $varValue = null;
        }

        return $varValue;
    }

    public function addParseMultiButton($arrButtons)
    {
        if (Input::post('FORM_SUBMIT') == 'tl_select' && isset($_POST['parseMulti'])) {
            $ids = Input::post('IDS');

            $arrAllResults = array();
            foreach ($ids as $id) {
                $arrAllResults = array_merge($arrAllResults, $this->parseSingle($id));
            }

            $this->processParseResult($arrAllResults);
            $this->redirect($this->getReferer());
        }

        $arrButtons['verbandErgMetaParse'] = '<input type="submit" name="parseMulti" id="parseMulti" class="tl_submit" accesskey="p" value="' . specialchars($GLOBALS['TL_LANG']['tl_verband_ergebnis']['parse']) . '"> ';
        return $arrButtons;
    }

    public function addParseSingleButton($arrButtons)
    {
        if (Input::post('FORM_SUBMIT') == 'tl_verband_ergebnis' && isset($_POST['parseSingle'])) {
            if (Input::get('id')) {
                $this->processParseResult($this->parseSingle(Input::get('id')));
                $this->redirect($this->getReferer());
            }
        }

        $arrButtons['verbandErgMetaParse'] = '<input type="submit" name="parseSingle" id="parseSingle" class="tl_submit" accesskey="p" value="' . specialchars($GLOBALS['TL_LANG']['tl_verband_ergebnis']['parse']) . '"> ';
        return $arrButtons;
    }

    private function parseSingle($id)
    {
        $objErgebnis = ErgebnisModel::findByPk($id);
        if ($objErgebnis) {
            return $objErgebnis->parseFiles();
        }
    }

    private function processParseResult($arrAllResults)
    {
        if (count($arrAllResults) == 0) {
            Message::addError("Es konnten keine Titel der Ergebnisdateien eingelesen werden.");
        } else {
            Message::addConfirmation("Titel der Ergebnisdateien eingelesen.");
            foreach ($arrAllResults as $objResult) {
                $strMessage = sprintf('%1$s/%2$s => %3$s', dirname($objResult->file), basename($objResult->file), $objResult->title);
                if ($objResult->modified) {
                    $strMessage .= " (<strong>geändert</strong>)";
                } else {
                    $strMessage .= " (nicht geändert)";
                }
                Message::addInfo($strMessage);
            }
        }
    }

    public function addResetMultiButton($arrButtons)
    {
        if (Input::post('FORM_SUBMIT') == 'tl_select' && isset($_POST['resetMulti'])) {
            $ids = Input::post('IDS');

            $arrAllResults = array();
            foreach ($ids as $id) {
                $arrAllResults = array_merge($arrAllResults, $this->resetSingle($id));
            }

            $this->processResetResult($arrAllResults);
            $this->redirect($this->getReferer());
        }

        $arrButtons['verbandErgMetaReset'] = '<input type="submit" name="resetMulti" id="resetMulti" class="tl_submit" accesskey="r" value="' . specialchars($GLOBALS['TL_LANG']['tl_verband_ergebnis']['reset']) . '"> ';
        return $arrButtons;
    }

    public function addResetSingleButton($arrButtons, \Contao\DC_Table $table)
    {
        if (Input::post('FORM_SUBMIT') == 'tl_verband_ergebnis' && isset($_POST['resetSingle'])) {
            if (Input::get('id')) {
                $this->processResetResult($this->resetSingle(Input::get('id')));
                $this->redirect($this->getReferer());
            }
        }

        $arrButtons['verbandErgMetaReset'] = '<input type="submit" name="resetSingle" id="resetSingle" class="tl_submit" accesskey="r" value="' . specialchars($GLOBALS['TL_LANG']['tl_verband_ergebnis']['reset']) . '"> ';
        return $arrButtons;
    }

    private function resetSingle($id)
    {
        $objErgebnis = ErgebnisModel::findByPk($id);
        if ($objErgebnis) {
            return $objErgebnis->resetFiles();
        }
    }

    private function processResetResult($arrAllResults)
    {
        if (count($arrAllResults) == 0) {
            Message::addError("Es konnten keine Dateien ermittelt werden.");
        } else {
            Message::addConfirmation("Metadaten-Zurücksetzung durchgeführt.");
            foreach ($arrAllResults as $objResult) {
                $strMessage = $objResult->file;
                if ($objResult->modified) {
                    $strMessage .= " (<strong>zurückgesetzt</strong>)";
                } else {
                    $strMessage .= " (nicht zurückgesetzt)";
                }
                Message::addInfo($strMessage);
            }
        }
    }
}
