<?php
declare(strict_types=1);

namespace LTVBerlin\Contao\LTVBerlinBundle\Controller\FrontendModule;

use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FilesModel;
use Contao\ModuleModel;
use Contao\StringUtil;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("ltvberlin_llz_aktuellerplan",
 *     category="ltvberlin",
 *     template="mod_ltvberlin_llz_aktuellerplan",
 *     renderer="forward"
 * )
 */
class LLZAktuelleRaumbelegungFrontendModuleController extends AbstractLLZFrontendModuleController
{
    public function __construct()
    {
        parent::__construct();
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        if ($model->multiSRC) {
            $t = FilesModel::getTable();
            $arrFolders = StringUtil::deserialize($model->multiSRC, true);
            $objFile = FilesModel::findOneBy(array("$t.type='file' AND $t.pid = ? AND $t.name = ?"), array($arrFolders[0], $this->getFilenameForCurrentPlan()));
            if ($objFile) {
                $template->plan = $this->convertToPlan($objFile, $this->currentYear, $this->currentWeekNumber);
                $template->week = $this->currentWeekNumber;
                $template->year = $this->currentYear;
            }
        }
        return $template->getResponse();
    }
}
