<?php
declare(strict_types=1);

namespace LTVBerlin\Contao\LTVBerlinBundle\Controller\FrontendModule;

use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\ModuleModel;
use Contao\Template;
use Doctrine\DBAL\Connection;
use LTVBerlin\Contao\LTVBerlinBundle\Model\ErgebnisModel;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("ltvberlin_ergebnis_archiv",
 *     category="ltvberlin",
 *     template="mod_ltvberlin_ergebnis_archiv",
 *     renderer="forward"
 * )
 */
class ErgebnisArchivFrontendModuleController extends AbstractErgebnisFrontendModuleController
{
    public function __construct(Connection $defaultConnection, LoggerInterface $contaoErrorLogger)
    {
        parent::__construct($defaultConnection, $contaoErrorLogger);
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $jahr = $this->getRequestedYear($request);
        if (!$jahr) {
            $jahr = $this->aktuellesJahrLaden();
        }
        $template->jahr = $jahr;

        $ergebnisse = [];
        $ergebnisTemplate = $model->verband_ergebnis_template ?: 'ergebnis_default';
        $ergebnisModels = ErgebnisModel::findByJahr($jahr);
        if ($ergebnisModels) {
            foreach ($ergebnisModels as $ergebnisModel) {
                $ergebnisse[] = $this->parseErgebnis($ergebnisModel, $ergebnisTemplate, $model->jumpTo);
            }
        }
        $template->ergebnisse = new \ArrayIterator($ergebnisse);

        return $template->getResponse();
    }
}
