<?php

namespace LTVBerlin\Contao\LTVBerlinBundle\Controller\FrontendModule;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\FrontendTemplate;
use Contao\PageModel;
use Doctrine\DBAL\Connection;
use LTVBerlin\Contao\LTVBerlinBundle\Model\ErgebnisModel;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Request;

abstract class AbstractErgebnisFrontendModuleController extends AbstractFrontendModuleController
{
    protected Connection $connection;
    protected LoggerInterface $contaoErrorLogger;

    private ?string $requestedYear;

    protected function __construct(Connection $defaultConnection, LoggerInterface $contaoErrorLogger)
    {
        $this->connection = $defaultConnection;
        $this->contaoErrorLogger = $contaoErrorLogger;
    }

    protected function isUseAutoItem(): bool
    {
        return (bool)$GLOBALS['TL_CONFIG']['useAutoItem'];
    }

    protected function getRequestedYear(Request $request)
    {
        if (!isset($this->requestedYear)) {
            if ($this->isUseAutoItem()) {
                $this->requestedYear = \Input::get('auto_item');
            } else {
                $this->requestedYear = $request->get('jahr');
            }
        }
        return $this->requestedYear;
    }

    protected function aktuellesJahrLaden()
    {
        try {
            $stmt = $this->connection->prepare("SELECT MAX(YEAR(FROM_UNIXTIME(datumAnfang))) jahr FROM tl_verband_ergebnis");
            $result = $stmt->executeQuery();
            $row = $result->fetchAssociative();
            if ($row) {
                return $row['jahr'];
            }
            return null;
        } catch (\Exception $e) {
            $this->contaoErrorLogger->error('Error selecting max year', ['exception' => $e]);
            return null;
        }
    }

    protected function jahreLaden()
    {
        $jahre = [];
        try {
            $stmt = $this->connection->prepare("SELECT DISTINCT YEAR(FROM_UNIXTIME(datumAnfang)) jahr FROM tl_verband_ergebnis ORDER BY 1 DESC");
            $result = $stmt->executeQuery();
            foreach ($result->fetchAllAssociative() as $row) {
                $jahre[] = $row['jahr'];
            }
            $stmt->free();
        } catch (\Exception $e) {
            $this->contaoErrorLogger->error('Error selecting years', ['exception' => $e]);
        }
        return $jahre;
    }

    protected function parseErgebnis(ErgebnisModel $model, string $ergebnisTemplate, ?string $jumpTo): string
    {
        try {
            $template = new FrontendTemplate($ergebnisTemplate);
            $template->ergebnis = $model;
            if ($jumpTo) {
                $page = PageModel::findByPk($jumpTo);
                if ($page) {
                    if ($this->isUseAutoItem()) {
                        $template->url = $page->getFrontendUrl("/{$model->getJahr()}");
                    } else {
                        $template->url = $page->getFrontendUrl() . "?jahr={$model->getJahr()}";
                    }
                }
            }
            return $template->parse();
        } catch (\Exception $e) {
            $this->contaoErrorLogger->error('Error parsing result', ['exception' => $e]);
        }
    }
}
