<?php

/**
 * Contao Extension LTVBerlin
 *
 * Copyright (c) 2013-2014 Hendrik Heneke <hendrik@pixelwunder.net>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 */

namespace LTVBerlin;

use LTVBerlin\Kaderliste\KaderlisteExcelReader;

require_once __DIR__ . '/../vendor/autoload.php';

class ModuleKaderListeExcel extends \Module
{

	protected $strTemplate = 'mod_ltvberlin_kaderliste_paar_excel';

	public function generate()
	{
		if (TL_MODE == 'BE') {
			$objTemplate = new \BackendTemplate('be_wildcard');

			$objTemplate->wildcard = '### ' . utf8_strtoupper($GLOBALS['TL_LANG']['FMD']['ltvberlin_kader_liste_excel'][0]) . ' ###';
			$objTemplate->title = $this->headline;
			$objTemplate->id = $this->id;
			$objTemplate->link = $this->name;
			$objTemplate->href = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

			return $objTemplate->parse();
		}

		if ($this->verband_kader_turnierart == 'JMD') {
			$this->strTemplate = 'mod_ltvberlin_kaderliste_einzel_excel';
		}

		return parent::generate();
	}

	protected function compile()
	{
		$arrEntries = null;

		$strListe = $this->verband_kader_turnierart . " aktuell";
		$strGruppe = $this->verband_kader_gruppe;
		$blnGaeste = $this->verband_kader_gaeste > 0 ? true : false;

		if (!$this->verband_kader_turnierart) {
			$this->logError(sprintf("Kaderliste (Excel)/Fehlkonfiguration: Keine Turnierart definiert"));
		} elseif (!$this->verband_kader_gruppe) {
			$this->logError(sprintf("Kaderliste (Excel)/Fehlkonfiguration: Keine Trainingsgruppe definiert"));
		} else {
			if ($this->singleSRC) {
				$objFile = \FilesModel::findByPk($this->singleSRC);
				if (!$objFile) {
					$this->logError("Kaderliste (Excel)/Fehler: Datei-Datensatz nicht geladen");
				} elseif (!in_array($objFile->extension, array('xls', 'xlsx'))) {
					$this->logError("Kaderliste (Excel)/Fehler: Datei ist keine Excel-Datei");
				} else {
					$strPath = TL_ROOT . '/' . $objFile->path;
					$this->Template->stand = date('d.m.Y H:i', filemtime($strPath));
					try {
						$objReader = new KaderlisteExcelReader($strPath);
						$objKaderliste = $objReader->findKaderliste($strListe);
						if ($objKaderliste) {
							$arrEntries = $objKaderliste->getGruppe($strGruppe, $blnGaeste);
							if (count($arrEntries) == 0) {
								$this->logError(sprintf("Kaderliste (Excel): Datei enthält keine Einträge für Gruppe '%s', Gäste %s)", $strGruppe, $blnGaeste ? 'ja' : 'nein'));
							}
						} else {
							$this->logError(sprintf("Kaderliste (Excel): Datei enthält keine Worksheet mit dem Namen '%s'", $strListe));
							$this->log("Kaderliste (Excel): Datei {$objFile->path} enthält keine Worksheet mit dem Namen '{$strListe}'", get_class($this) . '::compile()', TL_ERROR);
						}
					} catch (\Exception $e) {
						$this->log("Kaderliste (Excel)/Exception: " . $e->getMessage(), get_class($this) . '::compile()', TL_ERROR);
					}
				}
			} else {
				$this->log("Kaderliste (Excel)/Fehlkonfiguration: Keine Quelldatei definiert", get_class($this) . '::compile()', TL_ERROR);
			}
		}

		if ($arrEntries == null) {
			$this->Template->paare = array();
		} else {
			$this->Template->paare = $arrEntries;
		}
	}

	private function logError($message)
	{
		$this->log($message . " (ID: " . $this->id . ")", get_class($this) . '::compile()', TL_ERROR);
	}
}