<?php
declare(strict_types=1);

namespace LTVBerlin\Contao\LTVBerlinBundle\Model;

class LizenzerhaltModel
{

    private array $einheiten = [];

    public function add(\stdClass $einheit)
    {
        $this->einheiten[] = $einheit;
    }

    public function getEinheiten(): \ArrayIterator
    {
        return new \ArrayIterator($this->einheiten);
    }

    public function getSumme(?string $lizenzart, ?string $schulungsart): int
    {
        if (!$lizenzart || !$schulungsart) {
            return 0;
        }

        $summe = 0;
        foreach ($this->getEinheiten() as $einheit) {
            if ($einheit->lizenzart == $lizenzart && $einheit->schulungsart == $schulungsart) {
                $summe += $einheit->ue;
            }
        }
        return $summe;
    }

    public function isEmpty(): bool
    {
        return count($this->einheiten) == 0;
    }
}
