<?php

namespace LTVBerlin\Contao\LTVBerlinBundle\EventListener;

use Contao\Backend;
use Contao\CoreBundle\DependencyInjection\Attribute\AsCallback;
use Contao\DataContainer;
use Contao\Image;
use Contao\StringUtil;

#[AsCallback(table: 'tl_files', target: 'list.operations.unzip.button')]
class UnzipOperationListener
{

    public function __invoke(array         $row,
                             ?string       $href,
                             string        $label,
                             string        $title,
                             ?string       $icon,
                             string        $attributes,
                             string        $table,
                             array         $rootRecordIds,
                             ?array        $childRecordIds,
                             bool          $circularReference,
                             ?string       $previous,
                             ?string       $next,
                             DataContainer $dc): string
    {
        $type = $row['type'] ?? null;
        $fileNameEncoded = $row['fileNameEncoded'] ?? '';

        if ($type === 'file' && (str_ends_with($fileNameEncoded, '.zip'))) {
            return sprintf(
                '<a href="%s" title="%s" %s>%s</a> ',
                Backend::addToUrl($href . '&amp;do=ltvberlin_unzip&amp;id=' . $row['id']),
                StringUtil::specialchars($title),
                $attributes,
                Image::getHtml('/bundles/ltvberlin/folder_zip.png', $label)
            );

        }

        return '';
    }
}
