<?php
declare(strict_types=1);

namespace LTVBerlin\Contao\LTVBerlinBundle\Controller\FrontendModule;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Framework\ContaoFramework;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\FrontendUser;
use Contao\ModuleModel;
use Contao\Template;
use Doctrine\DBAL\Connection;
use LTVBerlin\Contao\LTVBerlinBundle\Model\LizenzerhaltModel;
use LTVBerlin\Lizenzerhalt;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule("ltvberlin_samba_lizenzerhalt",
 *     template="mod_ltvberlin_samba_lizenzerhalt",
 *     category="ltvberlin",
 *     renderer="forward"
 * )
 */
class SambaLizenzerhaltFrontendModuleController extends AbstractFrontendModuleController
{
    private ContaoFramework $framework;
    private Connection $connection;

    public function __construct(ContaoFramework $framework, Connection $connection)
    {
        $this->framework = $framework;
        $this->framework->initialize(true);
        $this->connection = $connection;
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $template->contents = $this->generateContent($request);
        return $template->getResponse()->setPrivate();
    }

    private function getFrontendUser(): ?FrontendUser
    {
        $adapter = $this->framework->getAdapter(FrontendUser::class);
        return $adapter->getInstance();
    }

    private function getSambaId(): ?int
    {
        $user = $this->getFrontendUser();
        return $user ? $user->samba_id : null;
    }

    private function getRequestedZeitraumId(Request $request): int
    {
        return $request->query->getInt('lzr');
    }

    private function generateContent(Request $request): string
    {
        $sambaId = $this->getSambaId();
        $template = new FrontendTemplate($sambaId ? 'lze_anzeige' : 'lze_keine_id');

        if ($sambaId) {
            $zeitraeume = [];

            $stmt = $this->connection->prepare("SELECT lzrID AS id, lzrName AS label FROM tl_samba_lizenzzeitraum ORDER BY lzrName DESC");
            $result = $stmt->executeQuery();
            foreach ($result->fetchAllAssociative() as $row) {
                $zeitraeume[] = (object)$row;
            }
            $result->free();

            $template->zeitraeume = $zeitraeume;
            $template->selectId = uniqid('lzr');

            $lizenzerhalt = new LizenzerhaltModel();

            $requestedId = $this->getRequestedZeitraumId($request);
            $requestedZeitraum = null;
            if (count($zeitraeume) > 0) {
                if ($requestedId > 0) {
                    foreach ($zeitraeume as $z) {
                        if ($z->id == $requestedId) {
                            $requestedZeitraum = $z;
                        }
                    }
                }
                if (!$requestedZeitraum) {
                    $requestedZeitraum = $zeitraeume = $zeitraeume[0];
                }
                $template->zeitraum = $requestedZeitraum;
                $template->selected = $requestedZeitraum->id;
                $template->uri = $request->getPathInfo();

                if ($sambaId) {
                    $stmt = $this->connection->prepare('SELECT DISTINCT lze.lzeDatum AS datum, lze.lzeAnzahlUE AS ue, lza.lzaName AS lizenzart, sla.slaName AS schulungsart, ltv.ltvName AS ltv FROM tl_samba_lizenzerhalt lze INNER JOIN tl_samba_lizenzart lza ON lze.lzaID = lza.lzaID INNER JOIN tl_samba_schulungsart sla ON lze.slgID = sla.slaID INNER JOIN tl_samba_ltv ltv ON lze.ltvID = ltv.ltvID WHERE lze.perID = ? AND lze.lzrID = ? ORDER BY lza.lzaID, sla.slaID');
                    $result = $stmt->executeQuery([$sambaId, $requestedZeitraum->id]);
                    foreach ($result->fetchAllAssociative() as $row) {
                        $lizenzerhalt->add((object)$row);
                    }

                    $result->free();
                }
            }

            $template->lizenzerhalt = $lizenzerhalt;
        }

        return $template->parse();
    }
}
